import 'dart:developer';

class Attribute {
  Attribute({
    this.id,
    this.name,
    this.displayType,
    this.description,
    this.status,
    this.createdBy,
    this.updatedBy,
    this.createdAt,
    this.updatedAt,
  });

  int? id;
  String? name;
  String? displayType;
  String? description;
  int? status;
  dynamic createdBy;
  dynamic updatedBy;
  DateTime? createdAt;
  DateTime? updatedAt;


  factory Attribute.fromJson(Map<String, dynamic> json){

    String? productName = '';
    try{
      productName = json["name"];
    }catch(e,tr){
      log("Track -> : $tr");
      productName = "Attribute.dart at 31";
    }


    String productDescription = '';

    try{
      productDescription = json["description"];
    }catch(e,tr){
      productDescription = "Attribute.dart at 39";
    }

    return Attribute(
      id: json["id"],
      name: productName,
      displayType: json["display_type"],
      // description: json["description"] == null ? null : json["description"],
      description: productDescription,
      status: json["status"],
      // createdBy: json["created_by"],
      // updatedBy: json["updated_by"],
     // createdAt: DateTime.parse(json["created_at"]),
     // updatedAt: DateTime.parse(json["updated_at"]),
    );
  }

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "display_type": displayType,
        "description": description == null ? null : description,
        "status": status,
        // "created_by": createdBy,
        // "updated_by": updatedBy,
        //"created_at": createdAt?.toIso8601String(),
        //"updated_at": updatedAt?.toIso8601String(),
      };
}
